Include([[Data/levels/include/level_utils.lua]])

Level =
{
	MapSkinFilename = [[caves.lua]],
	MapGenScript = LevelUtils.MapGenFromSVG([[tutorial_structures.svg]]),
	Parameters =
	{
		MarineCount 		= 5,
		MaxHiveLevel 		= 4,
		MaxSpawnRate 		= 0.0,
		StartBPMultiplier   = 4/3,
		BPGainMultiplier    = 0.5,
	},
	Rules = 
	{
		AutoCapture 	= false,		--Destroying hives automatically counts as a capture
		NoPushback		= false,		--Can the player's points be captured?
		NoTowerRespawn  = true,         --Can the hive towers respawn?
	},
	Mutations =
	{
		CapturesPerMutation = 1,
		MaxMutations = 0,
		Default = [[disabled]],
		Active =
		{
		},
		Queue =
		{
		},
		Disabled =
		{
		},
	},
	MarineUpgrades = 
	{
		--Default = [[locked]],
		Active =
		{
			[[MU_TURRET]],
			[[MU_RECYCLE]],
		},
		Inactive =
		{
		},	
		Locked =
		{
		},		
	},

	OnDebugCall = function (mousePos)

		RecycleAllGoal:Enable()

	end		
		
}

LevelInit = LevelUtils.MakeGoal(
	nil,
	
	{[[NT_BEGIN_GAME]]},
	function (self, p_type, p_entId, p_pos, p_other)	

		GameWorld:SetSpawnRate(4.0)
		GameWorld:SetSpawnRateScalingOn(false)
		
		TurretBuildGoal:Enable()
		
		self:Disable()
	end)
LevelInit:Enable()




------------------------------------------------------------------------------- Start Building Turret
TurretBuildGoal = LevelUtils.MakeGoal(
	function (self)
		GameWorld:ShowText("Aw hell, who built this?\nWhat a damned mess - the bugs'll just march through.\n\nWe gotta shore this up before it's too late.", "Sarge")
		GameWorld:SetUIVisibility("constructionMenu", true)
		GameWorld:SetUIVisibility("armouryMenu", true)		

		GameWorld:SetUIHighlightArrow("constructionMenu", "Toggle:Armoury", true)
		GameWorld:SetUIHighlight("armouryMenu", "Place:Turret", true)
		
		GameWorld:SetEntityVisible("turretBuildArea", true)
		GameWorld:CreateTrainingArrow("turretBuildArea")
		
		eventArea = GameWorld:GetEntityById("turretBuildArea")
		self.event_pos = eventArea:GetPos()
		self.event_radius = eventArea:GetRadius()
		
		ScriptMgr:DoDelayedCall(15000,  function ()
		                                    if self.enabled then
                                                GameWorld:ShowText("You awake over there?\n\nOpen up the build menu and place a turret in the marked area.  Can't be wastin time here.", "Sarge")
                                            end
                                        end)
	end,
	
	{[[NT_ENTITY_BUILD_ORDERED]]},
	function (self, p_type, p_entId, p_pos, p_other)	
		if p_other ~= "Turret" then
			return
		end
		
		if not vect2f.IsDistLess(p_pos, self.event_pos, self.event_radius) then
			GameWorld:ShowText("Build it INSIDE the circle.  See that giant red ring on the HUD - yeah, that one.", "Sarge")
			return
		end
		
		self:Disable()
		
		TurretCompleteGoal:Enable()
	end,
	
	function (self)
		GameWorld:SetUIHighlightArrow("constructionMenu", "Toggle:Armoury", false)
		GameWorld:SetUIHighlight("armouryMenu", "Place:Turret", false)
		
		GameWorld:RemoveTrainingArrow("turretBuildArea")
	end)

	
------------------------------------------------------------------------------- Complete Turret
TurretCompleteGoal = LevelUtils.MakeGoal(
	function (self)
		GameWorld:ShowText("Good stuff.  It takes a while for our boys to build things, but it's sure worth it.\n\nHeck, I even do it right in the enemy's face when I'm attackin.", "Sarge")

		eventArea = GameWorld:GetEntityById("turretBuildArea")
		self.event_pos = eventArea:GetPos()
		self.event_radius = eventArea:GetRadius()
	end,
	
	{[[NT_ENTITY_BUILD_FINISHED]]},
	function (self, p_type, p_entId, p_pos, p_other)	
		if not vect2f.IsDistLess(p_pos, self.event_pos, self.event_radius) then
			return
		end
		
		self:Disable()
		
		CaptureAllObjective:Enable()
	end,
	
	function (self)
		GameWorld:KillEntity("turretBuildArea");
	end)


------------------------------------------------------------------------------- Dialogue Triggers
DialogueScript = LevelUtils.MakeGoal(
	function (self)
		self.capture_counter = 0
	end,
	
	{[[NT_CAPTURE_RECORD]]},
	function (self, p_type, p_entId, p_pos, p_other)	
		
        self.capture_counter = self.capture_counter + 1
        
        local texthdl = nil
        if self.capture_counter == 1 then
            texthdl = GameWorld:ShowText("Good morning Captain Drake.\n\nI understand that we will be working together.", "Scout")
        elseif self.capture_counter == 2 then
            texthdl = GameWorld:ShowText("I don't know if you noticed doctor, but we're a bit busy over here!\n\nWhy don't you go back to base, hmm?", "Sarge")
        elseif self.capture_counter == 3 then
            texthdl = GameWorld:ShowText("Then let me rephrase that, Captain.\n\nThe General has placed your platoon under my direction.  You work for me now.", "Scout")
        elseif self.capture_counter == 4 then
            texthdl = GameWorld:ShowText("We don't take orders from scientists.\n\nYou can tell that to Magnusson yourself.  Now stop botherin me when I'm fightin.", "Sarge")
        end
        
        if texthdl then
            ScriptMgr:DoDelayedCall(15000, function () texthdl:ClearText(); end)
        end
      
	end)
DialogueScript:Enable()


------------------------------------------------------------------------------- Tracked objective for capturing everything
CaptureAllObjective = LevelUtils.MakeGoal(
	function (self)
		GameWorld:SetUIVisibility("Objectives", true)
		GameWorld:AddObjective("winObj", "Capture all the enemy points")
		
		local texthdl = GameWorld:ShowText("Now we're rollin.  Let take the squad out for some shootin practice.\n\nClear out the enemy and don't forget the turrets.", "Sarge")
		ScriptMgr:DoDelayedCall(10000, function () texthdl:ClearText(); end)	
	end,
	
	{[[NT_ALL_POINTS_CAPTURED]]},
	function (self, p_type, p_entId, p_pos, p_other)
		GameWorld:ChangeObjectiveStatus("winObj", [[complete]])
	
		self:Disable()
	end)
	
------------------------------------------------------------------------------- Victory Condition - Capture All Points (short-circuit)
CaptureAllGoal = LevelUtils.MakeGoal(
	nil,
	
	{[[NT_ALL_POINTS_CAPTURED]]},
	function (self, p_type, p_entId, p_pos, p_other)
		RecycleAllGoal:Enable()
		
		self:Disable()
	end) 
CaptureAllGoal:Enable()	

recycleTargetsList = {}
function MarkRecyclable()

    --go through all structures and hilight the recycleable ones
    local entCount = GameWorld:GetEntityCount()
    for i=0,entCount-1 do
        local ent = GameWorld:GetEntityByIndex(i)
        
        if ent then
            local building = ent:ToCHumanBuilding()
            
            if building and building:GetIsRecyclable() then
                GameWorld:CreateTrainingArrow(building)
                
                table.insert(recycleTargetsList, ent:GetHandle())
            end
        end
    end 

    return recyclable

end

function filter_inplace(t, predicate)
    local j = 1
     
    for i = 1,#t do
        local v = t[i]
        if predicate(v) then
            t[j] = v
            j = j + 1
        end
    end
     
    while t[j] ~= nil do
        t[j] = nil
        j = j + 1
    end
     
    return t
end

------------------------------------------------------------------------------- Recycle all
RecycleAllGoal = LevelUtils.MakeGoal(
	function (self)
		if self.ran_once then
		    GameWorld:ShowText("No, no, no.  I told you to recycle it all!\n\nWe need 37 BP to go on here", "Sarge")
        else
		    GameWorld:ShowText("Good work men. Intel's squawking that a large attack's comin from the west.\n\nLet's recycle everythin to return our metal.  Don't worry, you get 100% of it back.", "Sarge")
        end
        
        self.ran_once = true

		GameWorld:SetUIHighlightArrow("commandMenu", "Command:Recycle", true)
		GameWorld:SetUIHighlightArrow("ResourceGroup", "bp_counter", true)
		
        MarkRecyclable()
        RecycleMarkScript:Enable()     
	end,
	
	{[[NT_ENTITY_RECYCLED]]},
	function (self, p_type, p_entId, p_pos, p_other)	  

        filter_inplace(recycleTargetsList, function(p_handle) return p_handle:GetPtr() ~= nil and p_handle:GetPtr():GetId() ~= p_entId end)

        if #recycleTargetsList > 0 then
			return
		end
		
		self:Disable()
		
        if GameWorld:GetBuildPoints() >= 37 then
            CrateCaptureGoal:Enable()
		else
		    RecycleMarinesGoal:Enable()
		end
		
	end,
	
	function (self)        
        GameWorld:SetUIHighlightArrow("commandMenu", "Command:Recycle", false)
        GameWorld:SetUIHighlightArrow("ResourceGroup", "bp_counter", false)
	end)
		
--- Mark Recyclable things
RecycleMarkScript = LevelUtils.MakeGoal(
	function (self)
	end,
	
	{[[NT_ENTITY_BUILD_FINISHED]]},
	function (self, p_type, p_entId, p_pos, p_other)	  

        local ent = GameWorld:GetEntityById(p_entId)
        if ent then
            local building = ent:ToCHumanBuilding()
            
            if building and building:GetIsRecyclable() then
                GameWorld:CreateTrainingArrow(building)
                
                table.insert(recycleTargetsList, ent:GetHandle())
                
                if not RecycleAllGoal.enabled then
                    RecycleMarinesGoal:Disable()
                    RecycleAllGoal:Enable()
                end
            end
        end

	end,
	
	function (self)
	end)

------------------------------------------------------------------------------- Recycle marines
RecycleMarinesGoal = LevelUtils.MakeGoal(
	function (self)
		GameWorld:ShowText("We're goin to have to send some of the boys back to base too\n\nWe need turrets more than grunts right now", "Sarge")

		GameWorld:SetUIHighlightArrow("ResourceGroup", "bp_counter", true)
		GameWorld:SetUIHighlightArrow("MarineSpawnGroup", "MarineDespawnButton", true)   
	end,
	
	{[[NT_MARINE_DESPAWNED]]},
	function (self, p_type, p_entId, p_pos, p_other)	  

        if GameWorld:GetBuildPoints() < 37 then
			return
		end
		
		self:Disable()
		
		CrateCaptureGoal:Enable()
	end,
	
	function (self)
		RecycleMarkScript:Disable()
		
        GameWorld:SetUIHighlightArrow("ResourceGroup", "bp_counter", false)	
		GameWorld:SetUIHighlightArrow("MarineSpawnGroup", "MarineDespawnButton", false)
	end)

------------------------------------------------------------------------------- Capture 3 BP Crates
CrateCaptureGoal = LevelUtils.MakeGoal(
	function (self)
		GameWorld:ShowText("Hold on, looks like we'll need more metal here.\n\nI'm gonna call in a chopper with extras.", "Sarge")

        CrateDrop:Enable()
        self.crates_captured = 0
        
        GameWorld:SetEntityVisible("crateReturnArea", true)
		GameWorld:CreateTrainingArrow("crateReturnArea")
	end,
	
	{[[NT_POWERUP_CAPTURED]]},
	function (self, p_type, p_entId, p_pos, p_other)	  

        if p_other ~= "CBPCrate" then
			return
		end
		
		self.crates_captured = self.crates_captured + 1
		
		if self.crates_captured < 3 then
		    return
		end
		
		self:Disable()
		
		DefendAreaGoal:Enable()
	end,
	
	function (self)
		GameWorld:KillEntity("crateReturnArea")
		GameWorld:RemoveTrainingArrow("crateDropArea")
	end)		

		
------------------------------------------------------------------------------- Build Several Turrets
DefendAreaGoal = LevelUtils.MakeGoal(
	function (self)
		self.turret_count = 6
		self.crate_drop_allowed = true
		
		GameWorld:ShowText("Now that we're good on the metal, let's fortify the path to the west.\n\nI say " .. self.turret_count .. " turrets should tear those aliens to shreds.", "Sarge")
        GameWorld:SetEventIndicator(string.format("%d Turrets Left", self.turret_count))
        
 		GameWorld:SetEntityVisible("defendBuildArea", true)
		GameWorld:CreateTrainingArrow("defendBuildArea")
        
		eventArea = GameWorld:GetEntityById("defendBuildArea")
		self.event_pos = eventArea:GetPos()
		self.event_radius = eventArea:GetRadius()
		
		RecycleMarkScript:Disable()
	end,
	
	{[[NT_ENTITY_BUILD_FINISHED]]},
	function (self, p_type, p_entId, p_pos, p_other)	
		if not vect2f.IsDistLess(p_pos, self.event_pos, self.event_radius) then
			GameWorld:CreateTrainingArrow(p_entId)
			GameWorld:ShowText("Not that I don't appreciate creativity, but you gotta build the turrets in that big red circle.\n\nThink you can do that?", "Sarge")

            return
		end
		
		self.turret_count = self.turret_count - 1
		GameWorld:SetEventIndicator(string.format("%d Turrets Left", self.turret_count))
		
        if GameWorld:GetBuildPoints() < 7 and self.crate_drop_allowed then
			
			self.crate_drop_allowed = false
		end
		
		if self.turret_count > 0 then
		    return
        end
		   
		self:Disable()
		
		GameWorld:ShakeCamera(1.0, 500, GameWorld:GetCameraPos())
		GameWorld:ShowText("Shhhhhhhhh!\n\nYou feel that?", "Sarge")
		ScriptMgr:DoDelayedCall(4000,   function ()
                                            FinalAttackGoal:Enable()
                                        end)
                                        
	end,
	
	function (self)
		GameWorld:KillEntity("defendBuildArea");
		
        GameWorld:SetEventIndicator("")
	end)
		
		
------------------------------------------------------------------------------- Chopper Delivery (BP)
CrateDrop = LevelUtils.MakeGoal(
	function (self)	
		local crateArea = GameWorld:GetEntityById("crateDropArea");
		if crateArea then
			local chopper = GameWorld:SpawnChopper(vect2f(0.3, 1.0), crateArea:GetPos())
			chopper:SetMission(ChopperOrder.CO_DELIVERY, crateArea:GetPos(), "Crates")
		end
		
	end,
	
	{[[NT_CHOPPER_DELIVERY]]},
	function (self, p_type, p_entId, p_pos, p_other)
		
		if p_other ~= "Crates" then
			return
		end
		
		local crate1 = GameWorld:CreateEntity("BPCrate", "", p_pos + vect2f(3.5,0))
		local crate2 = GameWorld:CreateEntity("BPCrate", "", p_pos + vect2f(-3.5,3.5))
		local crate3 = GameWorld:CreateEntity("BPCrate", "", p_pos + vect2f(-3.5,-3.5))
		
		--GameWorld:CreateTrainingArrow(crate1)
		--GameWorld:CreateTrainingArrow(crate2)
		--GameWorld:CreateTrainingArrow(crate3)
		
		GameWorld:CreateTrainingArrow("crateDropArea")
		
		GameWorld:ShowText("Ding ding, dinner is ready!\n\nYou can order one of your boys to drag those crates back to a point.\nThat'll get us more metal.", "Sarge")
	
		self:Disable()
	end)

------------------------------------------------------------------------------- Chopper Delivery (Ammo)
CrateDropAmmo = LevelUtils.MakeGoal(
	function (self)	
		local crateArea = GameWorld:GetEntityById("ammoDropArea");
		if crateArea then
			local chopper = GameWorld:SpawnChopper(vect2f(0.3, 1.0), crateArea:GetPos())
			chopper:SetMission(ChopperOrder.CO_DELIVERY, crateArea:GetPos(), "AmmoCrates")
		end
		
	end,
	
	{[[NT_CHOPPER_DELIVERY]]},
	function (self, p_type, p_entId, p_pos, p_other)
		
		if p_other ~= "AmmoCrates" then
			return
		end
		
		local crate1 = GameWorld:CreateEntity("AmmoCrate", "", p_pos + vect2f(3.5,0))
		local crate2 = GameWorld:CreateEntity("AmmoCrate", "", p_pos + vect2f(-3.5,3.5))
		local crate3 = GameWorld:CreateEntity("AmmoCrate", "", p_pos + vect2f(-3.5,-3.5))
			
		self:Disable()
	end)		
		
------------------------------------------------------------------------------- Final Attack
FinalAttackGoal = LevelUtils.MakeGoal(
	function (self)	
		--spawn hive
		spawnLoc = GameWorld:GetEntityById("spawnLoc")
	
		local hive = GameWorld:SpawnHive(spawnLoc:GetPos())
		self.hive_id = hive:GetId()
		
		local nSpawn = 7
		for i=1,nSpawn do
			local deltaV = vect2f.MakePolar(5.0, i/nSpawn*math.pi*2)
			GameWorld:CreateSpawnerAttack( spawnLoc:GetPos() + deltaV, GameWorld:GetEntityById("firstPoint"):GetPos() + deltaV)
		end

        GameWorld:ShakeCamera(5.0, 100, GameWorld:GetCameraPos())
        
        GameWorld:AddObjective("finalObj", "Defeat the attack")
        
		GameWorld:ShowText("Where in the seven hells did that thing come from?\n\nHOLD THE LINE DEVILS!", "Sarge")
		
		ScriptMgr:DoDelayedCall(7000,   function ()
                                            CrateDropAmmo:Enable()
                                        end)		
	end,
	
	{[[NT_ENTITY_DESTROYED]]},
	function (self, p_type, p_entId, p_pos, p_other)
		if p_entId ~= self.hive_id then
			return
		end

        GameWorld:ChangeObjectiveStatus("finalObj", [[complete]])
		
		GameWorld:ShowText("Had me worried there for a while.\n\nGood job building that defense - didn't even break a sweat there.", "Sarge")
		ScriptMgr:DoDelayedCall(4000,   function ()
                                            GameWorld:ClearText()
                                            GameWorld:GameOver(true)
                                        end)

		self:Disable()
	end)
	